cd "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/"

clear

foreach type in tavg tmin tmax {

global anom_start = 2004
global anom_end = 2014
global station_years = 5

global file ushcn_metadata
global adj_series "Without CRN"
use "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/HCN Data/USHCN $adj_series FLs.52j.`type'.dta", clear
run anomaly_grid_cell_calc.do
rename avg ushcn_`type'_adj
drop if date == . | ushcn_`type'_adj == .
sort gridbox date grid_weight
save ushcn_`type'_adj_gridded.dta, replace

global file ushcn_metadata
global adj_series "With CRN"
use "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/HCN Data/USHCN $adj_series FLs.52j.`type'.dta", clear
run anomaly_grid_cell_calc.do
rename avg ushcn_`type'_adj_crn
drop if date == . | ushcn_`type'_adj_crn == .
sort gridbox date grid_weight
save ushcn_`type'_adj_crn_gridded.dta, replace

global file ushcn_metadata
use "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/HCN Data/USHCN raw.`type'.dta", clear
run anomaly_grid_cell_calc.do
rename avg ushcn_`type'_raw
drop if date == . | ushcn_`type'_raw == .
sort gridbox date grid_weight
save ushcn_`type'_raw_gridded.dta, replace

sort gridbox date grid_weight
merge gridbox date grid_weight using ushcn_`type'_adj_gridded
keep if _merge == 3
drop _merge
sort gridbox date grid_weight
merge gridbox date grid_weight using ushcn_`type'_adj_crn_gridded
keep if _merge == 3
drop _merge

sort gridbox date grid_weight

collapse (mean) ushcn_`type'_adj_crn ushcn_`type'_adj ushcn_`type'_raw [iweight = grid_weight], by (date)

keep if year(dofm(date)) >= 2004

gen hcn_adj_diffs = ushcn_`type'_adj_crn - ushcn_`type'_adj

sort date
#delimit ;
twoway 
	(line ushcn_`type'_raw date, lwidth(thin) lcolor(blue))
	(line ushcn_`type'_adj_crn date, lwidth(thin) lcolor(purple))
	(line ushcn_`type'_adj date, lwidth(thin) lcolor(red))
    ,
    ytitle("`type' anomaly", size(medsmall))
  	xtitle("", size(small))
  	xlabel(528 "2004" 552 "2006" 576 "2008" 600 "2010" 624 "2012" 648 "2014",labsize(medium))
  	ylabel(4(-2)-3, gmax glcolor(black) glpattern(dot) labsize(medium)) 
  	graphregion(color(white) lcolor(ebg))
  	legend(region(fcolor(white) lcolor(white)) size(small) position(12) label(1 "USHCN Raw")  label(2 "USHCN Adj with USCRN") label(3 "USHCN Adj no USCRN") order(1 2 3) col(3))
	saving(conus_gridded_`type', replace)
	;
#delimit cr

drop if _n == _N

sort date
#delimit ;
twoway 
	(line hcn_adj_diffs date, lwidth(thin) lcolor(black))
    ,
    ytitle("`type' differences", size(medsmall))
  	xtitle("", size(small))
  	xlabel(528 "2004" 552 "2006" 576 "2008" 600 "2010" 624 "2012" 648 "2014",labsize(medium))
  	ylabel(-0.02(0.01)0.02, gmax glcolor(black) glpattern(dot) labsize(medium)) 
  	graphregion(color(white) lcolor(ebg))
  	legend(off)
	saving(conus_gridded_`type'_diffs, replace)
	;
#delimit cr

*graph export "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/Images/`type' HCN Raw Adj CRN thin.png", replace width(1000)

}


grc1leg conus_gridded_tmax.gph conus_gridded_tmin.gph conus_gridded_tavg.gph conus_gridded_tmax_diffs.gph conus_gridded_tmin_diffs.gph conus_gridded_tavg_diffs.gph, colfirst cols(2) row(3) position(6) legendfrom(conus_gridded_tavg.gph) graphregion(fcolor(white)) imargin(0 0 0 0)
graph export "CONUS average combined sans crn test.png", replace width(1000)

